using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("collateral_type")]
[Index("Name", Name = "uk_collateral_type_name", IsUnique = true)]
public partial class CollateralType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("CollateralType")]
    public virtual ICollection<CreditLimitCollateral> CreditLimitCollaterals { get; set; } = new List<CreditLimitCollateral>();
}
