#!/usr/bin/env zsh
moduleName=$(jq -r '."fast.module.name"' ../.vscode/settings.json | cut -d'.' -f2)
siteFileName="${moduleName}_site.7z"
publishDir="$HOME/Code/-Published"
current_date=$(date "+%Y-%m-%d")
hostname="ftp.implefast.com"
username="superior"
password="sngc fast"
targetPath="transfer/$current_date"
7zz a -t7z "${publishDir}/${siteFileName}" "${publishDir}/*" -mx1 "-xr!AfterPublish*" "-xr!settings.json"
find $publishDir -type f ! -name "*.7z" -delete
echo -e "mkdir ${targetPath}\nput ${publishDir}/${siteFileName} ${targetPath}\nbye" | sshpass -p "$password" sftp -o StrictHostKeyChecking=no $username@$hostname
rm -rf $publishDir/*
echo "Publish Complete"
