using Microsoft.OData.Edm;
using Microsoft.OData.ModelBuilder;

Fast.Shared.ProgramShared.CustomEdmModel = Helper.GetCustomEdmModel();
Fast.Shared.ProgramShared.Configure(args, Type.GetType("Fast.Logic.JobsHelper"));
await Fast.Shared.ProgramShared.RunAsync();

namespace Fast.Web
{
    public static class Helper
    {
        public static IEdmModel GetCustomEdmModel()
        {
            var builder = new ODataConventionModelBuilder();

            builder.Function("GetPayoutTypeItems").Returns<PayoutTypeListItem>();
            builder.Function("GetProcessorItems").Returns<ProcessorListItem>();
            builder.Function("GetPlantItems").Returns<PlantListItem>();
            builder.Function("GetProducerFeeTest").Returns<SomeTestProducerModel>();
            builder.Function("GetProducerFeeItems").Returns<ProducerFeeListItem>();
            builder.Function("GetPlantStatementOptionsItems").Returns<PlantStatementOptionsListItem>();
            builder.Function("GetPlantStatementPricesItems").Returns<PlantStatementPricesListItem>();
            builder.Function("GetPlantStatementItems").Returns<PlantStatementListItem>();

            return builder.GetEdmModel();
        }
    }
}
