﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Models
{
    public class ProducerFeeListItem
    {
        [Key] //need to set primary key for OData
        public int Id { get; set; } = 0;
        [Display(Name = "Producer")] public string ProducerName { get; set; } = "";
        [Display(Name = "Contract Date")] public DateOnly? ContractDate { get; set; }
        [Display(Name = "Effective Date")] public DateOnly? EffectiveDate { get; set; }
        [Display(Name = "Base Fee")] public decimal BaseFee { get; set; } = 0;
        [Display(Name = "Inc Fee")] public decimal? IncFee { get; set; } = 0;
        [Display(Name = "Fee Type")] public int FeeTypeId { get; set; } = 0;
        [Display(Name = "Fee Type Name")] public string FeeTypeName { get; set; } = "";
    }
}
