﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Models
{
    public class PlantStatementPricesListItem
    {
        [Key] //need to set primary key for OData
        public int Id { get; set; }
        [Display(Name = "Name")] public string Name { get; set; } = "";
        [Display(Name = "ProductionMonth")] public DateOnly ProductionMonth { get; set; }
        [Display(Name = "StatementDate")] public DateOnly StatementDate { get; set; }
        [Display(Name = "Plant")] public string Plant { get; set; } = "";
        [Display(Name = "Producer")] public string Producer { get; set; } = "";
        [Display(Name = "Ethane")] public decimal? EthanePrice { get; set; }
        [Display(Name = "Propane")] public decimal? PropanePrice { get; set; }
        [Display(Name = "NormalButane")] public decimal? NormalButanePrice { get; set; }
        [Display(Name = "IsoButane")] public decimal? IsoButanePrice { get; set; }
        [Display(Name = "NaturalGasoline")] public decimal? NaturalGasolinePrice { get; set; }
        [Display(Name = "Scrubber")] public decimal? ScrubberPrice { get; set; }
    }
}
