﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Models
{
    public class PlantStatementListItem
    {
        [Key]
        public int Id { get; set; }

        [Display(Name = "Production Month")] public DateOnly ProductionMonth { get; set; }
        [Display(Name = "Statement Date")] public DateOnly StatementDate { get; set; }
        [Display(Name = "Plant")] public string? Plant { get; set; }
        [Display(Name = "Producer")] public string? Producer { get; set; }
        [Display(Name = "Meter")] public string? Meter { get; set; }
        [Display(Name = "Processor or Inlet Pipe")] public string? StatementDescriptor { get; set; }
        [Display(Name = "Payout Type")] public string? PayoutType { get; set; }
        [Display(Name = "Combined Meters")] public string? CombinedMeters { get; set; }
    }
}
