﻿namespace Fast.Models;

public class PlantStatementDetail
{
    public int Id { get; set; }
    public DateOnly ProductionMonth { get; set; }
    public DateOnly StatementDate { get; set; }
    public string? StatementNotes { get; set; }
    public string? PlantNotes { get; set; }
    public int PlantId { get; set; }
    public int ProducerId { get; set; }
    public int? MeterId { get; set; }
    public int? StatementDescriptorId { get; set; }
    public int? PayoutTypeId { get; set; }
    public int? WellheadVolumeMcf { get; set; }
    public int? WellheadVolumeMmbtu { get; set; }
    public int? ProcessedVolumeMcf { get; set; }
    public int? ProcessedVolumeMmbtu { get; set; }
    public int? ShrinkMcf { get; set; }
    public int? ShrinkMmbtu { get; set; }
    public int? PlantFuelMcf { get; set; }
    public int? PlantFuelMmbtu { get; set; }
    public int? FlareMcf { get; set; }
    public int? FlareMmbtu { get; set; }
    public int? BypassMcf { get; set; }
    public int? BypassMmbtu { get; set; }
    public int? PlantGainLossMcf { get; set; }
    public int? PlantGainLossMmbtu { get; set; }
    public int? InKindPvrMcf { get; set; }
    public int? InKindPtrMmbtu { get; set; }
    public int? RecoveredCarbonDioxide { get; set; }
    public int? RecoveredEthane { get; set; }
    public int? RecoveredPropane { get; set; }
    public int? RecoveredIsoButane { get; set; }
    public int? RecoveredNormalButane { get; set; }
    public int? RecoveredNaturalGasoline { get; set; }
    public int? RecoveredScrubber { get; set; }
    public int? TheoreticalCarbonDioxide { get; set; }
    public int? TheoreticalEthane { get; set; }
    public int? TheoreticalPropane { get; set; }
    public int? TheoreticalIsoButane { get; set; }
    public int? TheoreticalNormalButane { get; set; }
    public int? TheoreticalIsoPentane { get; set; }
    public int? TheoreticalNormalPentane { get; set; }
    public int? TheoreticalNaturalGasoline { get; set; }
    public decimal? PtrCashoutPrice { get; set; }
    public decimal? PtrTrans { get; set; }
    public decimal? PtrFuelPercent { get; set; }
    public decimal? WellheadPtrPrice { get; set; }
    public decimal? LiquidsTakePercent { get; set; }
    public decimal? Taxes { get; set; }
    public decimal? FractionationFee { get; set; }
    public decimal? PlantProcessingFee { get; set; }
    public decimal? CarbonDioxideFee { get; set; }
    public decimal? CompressionFee { get; set; }
    public decimal? ElectricityFee { get; set; }
    public decimal? StabilizationFee { get; set; }
    public decimal? MiscellaneousFee { get; set; }
    public decimal? LiquidsLiftingFee { get; set; }
    public decimal? GpmCarbonDioxide { get; set; }
    public decimal? GpmEthane { get; set; }
    public decimal? GpmPropane { get; set; }
    public decimal? GpmIsoButane { get; set; }
    public decimal? GpmNormalButane { get; set; }
    public decimal? GpmIsoPentane { get; set; }
    public decimal? GpmNormalPentane { get; set; }
    public decimal? GpmHexanePlus { get; set; }
    public decimal? MolePercentNitrogen { get; set; }
    public decimal? MolePercentCarbonDioxide { get; set; }
    public decimal? MolePercentMethane { get; set; }
    public decimal? MolePercentEthane { get; set; }
    public decimal? MolePercentPropane { get; set; }
    public decimal? MolePercentIsoButane { get; set; }
    public decimal? MolePercentNormalButane { get; set; }
    public decimal? MolePercentIsoPentane { get; set; }
    public decimal? MolePercentNormalPentane { get; set; }
    public decimal? MolePercentHexane { get; set; }
    public decimal? MolePercentHeptane { get; set; }
    public int? PipelineGainLossMcf { get; set; }
    public int? PipelineGainLossMmbtu { get; set; }
    public int? AllocatedCarbonDioxide { get; set; }
    public int? AllocatedEthane { get; set; }
    public int? AllocatedPropane { get; set; }
    public int? AllocatedIsoButane { get; set; }
    public int? AllocatedNormalButane { get; set; }
    public int? AllocatedNaturalGasoline { get; set; }
    public int? AllocatedScrubber { get; set; }
    public int? PricesId { get; set; }
    public bool ChargeProducerFee { get; set; }
    public int? ElectionMcf { get; set; }
    public int? ElectionMmbtu { get; set; }
    public List<PlantStatementCombinedMeterDetail> CombinedMeters { get; set; } = new List<PlantStatementCombinedMeterDetail>();
}
