import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';
import { IdName, SaveType } from '../_shared/utils/util';

export interface Item {
  PlantStatementOptionsId: number;
  PlantId: number;
  PayoutTypeId: number;
  RequiredFields: string;
}

export interface Detail {
  plantstatementoptionsId: number;
  plantId: number;
  payoutTypeId: number;
  requiredFields: string;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  plants: IdName[];
  payoutTypes: IdName[];
  fieldNames: string[];
  requiredFields: string[];
}

@Injectable({
  providedIn: 'root'
})
export class PlantStatementOptionsService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/PlantStatementOptions`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/GetRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetPlantStatementOptionsItems`, state, null, false)
  }

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetPlantStatementOptionsItems`, state, null, fileNameOriginal);
  }
}
