import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';
import { SaveType } from '../_shared/utils/util';
export interface Item {
  PlantId: number;
  Plantname: string;
  IsActive: boolean;
}


export interface Detail {
  plantId: number;
  plantName: string;
  isActive: boolean;
}


export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class PlantService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/Plant`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/GetRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetPlantItems`, state, null, false)
  }

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetPlantItems`, state, null, fileNameOriginal);
  }

}
