import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';

export interface Item {
  PayoutTypeId: number;
  PayoutType: string;
  Description: string;
}

export interface Detail {
  payoutTypeName: string;
  payoutTypeId: number;
  description: string;
}

export enum SaveType {
  New = 1,
  Normal = 2
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class PayoutTypeService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/PayoutType`;
  http = inject(HttpClient);

  requireData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetPayoutTypeItems`, state, null, false)
  }

  getDetail(PayoutTypeName: string): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?PayoutTypeName=${PayoutTypeName}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(Name: string) {
    const url = `${this.baseUrl}/DeletePayoutType/${Name}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetPayoutTypeItems`, state, null, fileNameOriginal);
  }
}
