import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { getErrorMessage, } from '../utils/util';

@Injectable({ providedIn: 'root' })
export class MessageService {
  errorMessage$ = new BehaviorSubject<string>(null)
  infoMessage$ = new BehaviorSubject<string>(null)

  throw(error: unknown) {
    console.error(error);
    const errorMessage = getErrorMessage(error as unknown);
    this.errorMessage$.next(errorMessage);
  }

  info(message: string) {
    this.infoMessage$.next(message)
  }

}
