import { ChangeDetectionStrategy, ChangeDetectorRef, Component, computed, inject, input } from '@angular/core';
import { FAST_KENDO_COMMON } from '../../app.config';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { KENDO_TREEVIEW } from '@progress/kendo-angular-treeview';

@Component({
  selector: 'fast-treeview',
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_KENDO_COMMON, KENDO_TREEVIEW],
  providers: [{
    provide: NG_VALUE_ACCESSOR,
    multi: true,
    useExisting: FastTreeviewComponent
  }],
  template: `
  <kendo-treeview
  [class]="conditionalClasses()"
  [nodes]="nodes()"
  [textField]="textField()"
  kendoTreeViewHierarchyBinding
  [childrenField]="childrenField()"
  kendoTreeViewExpandable
  [isExpanded]="isExpanded()"
  />
  `
})
export class FastTreeviewComponent<T extends object> {
  cdr = inject(ChangeDetectorRef);

  nodes = input.required<T[]>();
  isExpanded = input<(item: object, index: string) => boolean>(() => true); // this is how the directive is used
  textField = input<string>("text");
  childrenField = input<string>("items");

  conditionalClasses = computed(() => {
    const classes = [] as string[];

    classes.push(...this.getCommonClasses());
    classes.push(...this.getLightBaseClasses());
    classes.push(...this.getDarkBaseClasses());

    const conditionalClasses = this.getConditionalClassesFromArrays(classes);
    return conditionalClasses;
  });


  getConditionalClassesFromArrays(classArray: string[]): { [key: string]: boolean } {
    const classes: { [key: string]: boolean } = {};
    classArray.forEach(className => {
      classes[className] = true;
    });
    return classes;
  }

  getCommonClasses() {
    return [
      "flex",
      "flex-grow",
      "overflow-auto",
    ]
  }

  getLightBaseClasses() {
    return [
      "",
    ];
  }

  getDarkBaseClasses() {
    return [
      ""
    ];
  }
}
