import { Directive, HostListener, ElementRef, Input, inject } from '@angular/core';

@Directive({
  selector: '[active-class]'
})
export class ActiveClassDirective {
  @Input('active-class') activeClass: string;

  private elementRef = inject(ElementRef)

  @HostListener('mousedown') onMouseDown() {
    this.update('add');
    setTimeout(() => {
      this.update('remove');
    }, 1000);
  }

  @HostListener('mouseup') onMouseUp() {
    this.update('remove');
  }

  protected update(action: 'add' | 'remove'): void {
    const elem = this.elementRef.nativeElement as HTMLElement;
    this.activeClass.split(' ').forEach(item => elem.classList[action](item));
  }
}
