﻿namespace Fast.Models;

[Serializable]
public class IdNameActive : IEquatable<IdNameActive>
{
    public int Id;
    public string Name = "";
    public bool IsActive;

    public IdNameActive()
    {
    }

    public IdNameActive(int Id, string Name, bool IsActive)
    {
        this.Id = Id;
        this.Name = IsActive ? Name : "{Inactive} " + Name;
        this.IsActive = IsActive;
    }

    public override bool Equals(object? obj)
    {
        return Equals(obj as IdNameActive);
    }

    public bool Equals(IdNameActive? other)
    {
        return Id == other?.Id &&
               Name == other?.Name &&
               IsActive == other?.IsActive;
    }

    public override int GetHashCode()
    {
        return HashCode.Combine(Id, Name, IsActive);
    }

    public static bool operator ==(IdNameActive pair1, IdNameActive pair2)
    {
        return EqualityComparer<IdNameActive>.Default.Equals(pair1, pair2);
    }

    public static bool operator !=(IdNameActive pair1, IdNameActive pair2)
    {
        return !(pair1 == pair2);
    }
}
