﻿using System.ComponentModel;

namespace Fast.Models;

public static partial class Enums
{
    public enum AdderType
    {
        None = 0,
        Fuel = 1,
        FirmTransport = 2,
        InterruptibleTransport = 3,
        IntrastateTransport = 4,
        MgmtFee = 5,
        MiscFee = 6,
        PremDisc = 7,
        Basis = 8,
        InvoicePassThrough = 9,
        FirmFixedTransport = 10,
        FirmVariableTransport = 11,
        KYSchoolTax = 49
    }

    public enum LoadType
    {
        Actual,
        Forecast
    }

    public enum DateStyle
    {
        DateRange,
        MonthRange,
        Unknown
    }

    public enum MemoType
    {
        Guarantee = 1,
        LetterOfCredit = 2,
        NetSet = 3
    }

    public enum DocType
    {
        Confirm = 1,
        Ticket = 2
    }

    public enum ArchiveType
    {
        Inserted = 1,
        Updated = 2,
        Deleted = 3,
        Expired = 4
    }

    public enum DealType
    {
        Unknown = 0,
        Baseload = 2,
        Swing = 3,
        Demand = 5,
        Basis = 6,
        Firm = 7,
        OFO = 8,
        Triggers = 9,
        Master = 10,
        DayTrade = 11  //AKA "Firm Variable"
    }

    public enum DealPurpose
    {
        General = 8,
        Trigger = 9,
        EFP = 10,
        PhysicalExchange = 11,
        PseudoDeal = 13,
        EFS = 14,
        Hedge = 15,
        Spec = 16,
        Storage = 17,
        DirectSaleProducerPaid = 19,
        DirectSaleInternalPaid = 20,
        PTR = 21,
        Cashout = 22,
        LU = 23,
        Imbalance = 24
    }

    public enum BuyButton
    {
        Buy = 1,
        Sell = -1
    }

    public enum FixedPriceButton
    {
        FixedPrice = 1,
        IndexPrice = 0
    }

    public enum DealCategory
    {
        Unknown = -1,
        FixedPrice = 0,
        IndexPrice = 1,
        EFP = 2,
        General = 3,
        Demand = 4
    }

    public enum DealStatus
    {
        Unknown = -1,
        Pending = 1,
        Completed,
        Pricing,
        EFP_NotPriced,
        EFP_PricedButNotPosted,
        EFP_Posted,
        EFS_NotPriced,
        EFS_PricedButnotPosted,
        EFS_Posted,
        Approved = 13,
        UnderDispute = 14,
        FullyExecuted = 15,
        ExecutedInternal = 16,
        EnteredFromSOS = 17
    }

    public enum DealStatusType
    {
        Pending = 1,
        Approved = 2,
        FullyExecuted = 3
    }

    public enum PrefixType
    {
        [Description("RTK")]
        RunTicket = 111
    }

    public enum TransactionType
    {
        [Description("GAS")]
        PhysicalGas = 1,
        [Description("POW")]
        PhysicalPower = 2,
        [Description("FUT")]
        Futures = 3,
        [Description("OPT")]
        Options = 4,
        [Description("BSW")]
        BasisSwaps = 5,
        [Description("FFS")]
        FixedFloatingSwaps = 6,
        [Description("SSW")]
        SwingSwaps = 7,
        Structuring = 8,
        [Description("NGL")]
        PhysicalNGL = 9,
        Transportation = 10,
        [Description("CRO")]
        PhysicalCrudeOil = 11,
        Inventory = 12,
        InTrasit = 13,
        Equity = 104,
        FX = 105,
        Bonds = 106,
        [Description("SWP")]
        Swaps = 111
    }

    public enum OptionExercise
    {
        Unknown = -1,
        Financial,
        Physical
    }

    public enum OptionType
    {
        Unknown = -1,
        OnFutures = 4,
        Swaption = 5,
        OTC = 6
    }

    public enum TradingType
    {
        Options_On_Futures = 1,
        Futures = 2
    }

    public enum PriceType
    {
        Unknown = -1,
        NYMEX = 1,
        BASIS = 2,
        INDEX = 3
    }

    public enum PriceAverageType
    {
        Unknown,
        CurrentDay = 1,
        CurrentWeekAverage = 2,
        CurrentMonthAverage = 3,
        PriorDay = 4,
        PriorWeekAverage = 5,
        PriorMonthAverage = 6
    }

    public enum CallPut
    {
        OptionPut = 0,
        OptionCall = 1
    }

    public enum InventoryTransactionTypes
    {
        Inventory = 12,
        GasLeasedStorage = 107,
        GasPipelineImbalances = 108,
        GasParkAndLoans = 109
    }

    public enum SettleType
    {
        Unknown,
        BusinessDays = 1,
        CalendarDays = 2
    }

    public enum BusinessRelationship
    {
        InternalEntity = 1,
        Producer = 2,
        FinancialOnlyTradingCounterparty = 3,
        TradingCounterparty = 4,
        Agency = 5,
        Bank = 6,
        Broker = 7,
        Processor = 8,
        Transporter = 9,
        VendorsOperating = 10,
    }

    public enum EntityType
    {
        InternalEntity = 1,
        Producer = 2,
        FinancialOnlyTradingCounterparty = 3,
        TradingCounterparty = 4,
        Agency = 5,
        Broker = 6,
        EndUser = 7,
        Transporter = 8,
        Processor = 9,
        LeaseOperator = 10,
        CrudeOilCounterparty = 11,
        CondensateSupplier = 13
    }

    public enum MeterTypeEnum
    {
        Wellhead = 1,
        PlantInlet = 2,
        PlantOutlet = 3,
        Fuel = 4,
        Bypass = 5,
        Lift = 6,
        Pool = 7,
        InterConnect = 8,
        Check = 9,
        BuyBack = 10,
        Chart = 11,
        EFM = 12,
        Flare = 13,
        CDP = 14,
        Rack = 17,
        SourWater = 18,
        Overhead = 19,
        Bottom = 20,
        Wellhead_Crude = 21
    }

    public enum PrivacyTypes
    {
        None = 0,
        PublicType = 1,
        CompanyWideType = 2,
        PrivateType = 3
    }

    public enum DocumentType
    {
        None = 0,
        UploadDocument = 1,
        Contract = 2,
        ConfirmationTicket = 3,
        Post = 4,
        Link = 5,
        SettlementDocument = 6,
        InvoiceDocument = 7
    }

    public enum UnitOfMeasure
    {
        MWH = 1,
        MMBBTU = 2,
        BBL = 3,
        GAL = 4,
        L = 5,
        MTH = 6,
        F = 7,
        C = 8,
        MCF = 9,
        ft2 = 10
    }

    public enum CurrencyType
    {
        USDollars = 1,
        CanadianDollars = 2,
        Euros = 3,
        Pounds = 4,
        Francs = 5,
        JapaneseYen = 6,
        ChineseYen = 7,
        MexicanPesos = 8,
        AustralianDollars = 10,
        BrazilianReal = 11
    }

    public enum QuickBooksTransactionType
    {
        Invoice = 1,
        CreditMemo = 2
    }

    public enum SalesTaxType
    {
        Reguar = 1,
        Tiered = 2,
        EnergyExemption = 3,
        ExciseTax = 4,
        ExtraSchoolTax = 5
    }

    public enum VolumeType
    {
        Daily = 0,
        Monthly = 1,
        Other = 2,
        Total = 3
    }

    public enum SaveType
    {
        New = 1,
        Normal = 2
    }

    public enum PadDirection
    {
        Right = 1,
        Left = 2
    }

    public enum BusinessType
    {
        Corporation = 1,
        LLC = 2,
        Partnership = 3,
        LP = 4,
        LLP = 5,
        Other = 6,
        Individual = 7
    }

    public enum ValPriceType
    {
        ForwardPrice = 1,
        PostedOrForwardPrice = 2,
        MostRecentPostedPrice = 3
    }

    public enum PriceCalcType
    {
        AllDays,
        TradeDays
    }

    public enum ContractDocType
    {
        UserUploaded = 1,
        NAESB = 2,
        Crude = 3,
        ExhibitB = 4,
        ExhibitC = 5,
        Amendment = 6
    }

    public enum ContractPaymentType
    {
        ExCWire = 1,
        ExCAch = 2,
        ExCAlt1Wire = 3,
        ExCAlt1Ach = 4,
        ExCAlt2Wire = 5,
        ExCAlt2Ach = 6,
        AccWire = 7,
        AccAch = 8,
    }

    public enum MarketType
    {
        ForwardCurve = 1,
        DailyIndex = 2,
        MonthlyIndex = 3,
        Basis = 4,
        InterestRate = 5,
        HeatRate = 6,
        Option = 7,
        FX = 8,
        Equity = 9,
        Bond = 10,
        OtherDerivative = 11,
        HourlyIndex = 13
    }

    public enum NotificationType
    {
        Confirmations = 1,
        Deals = 2,
        Points = 3,
        PaymentInstructions = 4,
        Invoices = 5
    }

    public enum PipelineType
    {
        Intrastate = 1,
        Interstate = 2,
        NonJurisdictional = 3
    }

    public enum PaidOnType
    {
        Actuals = 1,
        Nominations = 2
    }

    public enum ContractStatus
    {
        Pending = 1,
        CounterpartyToOriginate = 2,
        InNegotiation = 3,
        InReviewHere = 4,
        InReviewAtCounterparty = 5,
        Executed = 6,
        Terminated = 7,
        Other = 8
    }

    public enum IndexAliasType
    {
        ShortName = 1,
        PlattsId = 2,
        CmeName = 3,
        ArgusId = 4,
        Other = 99
    }

    public enum ContactType
    {
        Trading = 1,
        Technician = 2,
        OFO = 3,
        Invoice = 4,
        Confirmation = 5,
        Other = 99
    }

    public enum MarketIndexType
    {
        Daily = 0,
        Monthly = 1,
        Hybrid = 2
    }

    public enum ProductCategory
    {
        All = 0,
        NaturalGasAndLng = 1,
        CrudeOil = 2,
        NGLs = 3,
        RefinedProducts = 4,
        Power = 5,
        Coal = 6,
        Biofuels = 7,
        Metals = 8,
        AgriculturalProducts = 9
    }

    public enum Product
    {
        All = 0,
        NaturalGas = 1,
        LiquifiedNaturalGas = 2,
        CrudeOil = 3,
        Condensate = 4,
        Retrograde = 5,
        Ethane = 12,
        Propane = 13,
        IsoButane = 14,
        NormalButane = 15,
        NaturalGasoline = 16,
        YGrade = 17,
        UnspecifiedNgl = 18,
        Gasoline = 19,
        RBOBGasoline = 20,
        DieselULSD = 21,
        DieselLSD = 22,
        JetFuel = 23,
        HeatingOil = 24,
        Power = 26,
        Coal = 27,
        Biofuels = 28,
        LMECopper = 29,
        USCocoa = 30,
        UKCocoa = 31
    }

    public enum Benchmark
    {
        Global = 1,
        WTICrudeOil = 2,
        BrentCrudeOil = 3
    }

    public enum PaymentDateOption
    {
        TwentiethDayOfMonthFollowingMonthOfDelivery = 1,
        TwentyFifthDayOfMonthFollowingMonthOfDelivery = 2,
        TwentyEighthDayOfMonthFollowingMonthOfDelivery = 3,
        Custom = 4
    }

    public enum PaymentDateType
    {
        LastBusinessDay = 1,
        LastDay = 2,
        TwentySixthDay = 3,
        ThirtiethDay = 4,
        SecondWorkDayOfTheSecond = 5
    }

    public enum ActualType
    {
        Buy = 1,
        Sell = -1,
        Transfer = 0
    }

    public enum TariffType
    {
        CommodityCharge = 1,
        FuelLoss = 2,
        AnnualChargeAdjustment = 4,
        GatheringCharge = 5,
        HurricaneCharge = 6,
        OtherCharge = 7,
        ElectricPower = 8
    }

    public enum NumFormat
    {
        n0,
        n1,
        n2,
        n3,
        n4,
        n5,
        c2,
        c3,
        c4,
        c5,
        p2,
        p3,
        p4,
        p5,
        p6
    }

    public enum Portfolio
    {
        Unassigned = 1,
        BuySell = 2
    }
}
