﻿namespace Fast.Logic;

public class DateRange
{
    public DateOnly FromDate;
    public DateOnly ToDate;
    private readonly Enums.DateStyle dateStyle;
    readonly string monthRangeDisplayFormat = "MMMM yyyy";
    readonly string dateRangeDisplayFormat = "M/d/yyyy";
    readonly string saveFormat = "yyyy/MM/dd";

    public DateRange(Enums.DateStyle dateStyle)
    {
        this.dateStyle = dateStyle;
    }

    public DateRange(Enums.DateStyle dateStyle, DateOnly fromDate, DateOnly toDate)
    {
        FromDate = fromDate;
        ToDate = toDate;
        this.dateStyle = dateStyle;
    }

    public string DisplayText
    {
        get
        {
            if (this.dateStyle == Enums.DateStyle.Unknown)
                throw new Exception("Cannot get display text for an \"Unknown\" date style.");

            string result;
            string displayFormat = dateStyle == Enums.DateStyle.MonthRange ? monthRangeDisplayFormat : dateRangeDisplayFormat;
            if (dateStyle == Enums.DateStyle.DateRange && FromDate == ToDate)
                result = FromDate.ToString(displayFormat);
            else if (dateStyle == Enums.DateStyle.MonthRange && FromDate.Year == ToDate.Year && FromDate.Month == ToDate.Month)
                result = FromDate.ToString(displayFormat);
            else
                result = FromDate.ToString(displayFormat) + " to " + ToDate.ToString(displayFormat);

            return result;
        }
    }

    public string StringValue
    {
        get
        {
            string result;
            if (FromDate == ToDate)
                result = FromDate.ToString(saveFormat);
            else
                result = FromDate.ToString(saveFormat) + '-' + ToDate.ToString(saveFormat);
            return result;
        }
    }
}
