using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Keyless]
public partial class VwRptValuationDataDeal
{
    [Column("id")]
    public int? Id { get; set; }

    [Column("ticket_num", TypeName = "citext")]
    public string? TicketNum { get; set; }

    [Column("trading_date")]
    public DateOnly? TradingDate { get; set; }

    [Column("transaction_type", TypeName = "citext")]
    public string? TransactionType { get; set; }

    [Column("transaction_type_id")]
    public int? TransactionTypeId { get; set; }

    [Column("basis")]
    public double? Basis { get; set; }

    [Column("premium_or_discount")]
    public double? PremiumOrDiscount { get; set; }

    [Column("counterparty", TypeName = "citext")]
    public string? Counterparty { get; set; }

    [Column("counterparty_nickname", TypeName = "citext")]
    public string? CounterpartyNickname { get; set; }

    [Column("pipeline", TypeName = "citext")]
    public string? Pipeline { get; set; }

    [Column("pipe_short", TypeName = "citext")]
    public string? PipeShort { get; set; }

    [Column("point", TypeName = "citext")]
    public string? Point { get; set; }

    [Column("broker", TypeName = "citext")]
    public string? Broker { get; set; }

    [Column("price_index", TypeName = "citext")]
    public string? PriceIndex { get; set; }

    [Column("price_index2", TypeName = "citext")]
    public string? PriceIndex2 { get; set; }

    [Column("deal_purpose", TypeName = "citext")]
    public string? DealPurpose { get; set; }

    [Column("deal_type", TypeName = "citext")]
    public string? DealType { get; set; }

    [Column("internal_entity", TypeName = "citext")]
    public string? InternalEntity { get; set; }

    [Column("is_fixed_price")]
    public int? IsFixedPrice { get; set; }

    [Column("fixed_price")]
    public double? FixedPrice { get; set; }

    [Column("broker_account", TypeName = "citext")]
    public string? BrokerAccount { get; set; }

    [Column("book", TypeName = "citext")]
    public string? Book { get; set; }

    [Column("portfolio", TypeName = "citext")]
    public string? Portfolio { get; set; }

    [Column("strategy", TypeName = "citext")]
    public string? Strategy { get; set; }

    [Column("region", TypeName = "citext")]
    public string? Region { get; set; }

    [Column("nymex_execution_fee")]
    public double? NymexExecutionFee { get; set; }

    [Column("execution_margin")]
    public double? ExecutionMargin { get; set; }

    [Column("sales_margin")]
    public double? SalesMargin { get; set; }

    [Column("start_date")]
    public DateOnly? StartDate { get; set; }

    [Column("end_date")]
    public DateOnly? EndDate { get; set; }

    [Column("buy_button")]
    public int? BuyButton { get; set; }

    [Column("commission_per_contract")]
    public double? CommissionPerContract { get; set; }

    [Column("trader_short_name", TypeName = "citext")]
    public string? TraderShortName { get; set; }

    [Column("trader_name", TypeName = "citext")]
    public string? TraderName { get; set; }

    [Column("comments", TypeName = "citext")]
    public string? Comments { get; set; }

    [Column("internal_memo", TypeName = "citext")]
    public string? InternalMemo { get; set; }

    [Column("deal_purpose_id")]
    public int? DealPurposeId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("volume_type_id")]
    public int? VolumeTypeId { get; set; }

    [Column("contract_num", TypeName = "citext")]
    public string? ContractNum { get; set; }

    [Column("their_contract_num", TypeName = "citext")]
    public string? TheirContractNum { get; set; }

    [Column("is_hybrid_with_suffix")]
    public bool? IsHybridWithSuffix { get; set; }
}
