using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("sos_hidden_deal")]
[Index("DeliveryPointId", "ReceiptPointId", "ReceiptMeterId", "SupplyDealId", Name = "ix_sos_hidden_deal")]
public partial class SosHiddenDeal
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("delivery_point_id")]
    public int DeliveryPointId { get; set; }

    [Column("receipt_point_id")]
    public int? ReceiptPointId { get; set; }

    [Column("supply_deal_id")]
    public int? SupplyDealId { get; set; }

    [Column("receipt_meter_id")]
    public int ReceiptMeterId { get; set; }

    [Column("transfer_deal_id")]
    public int? TransferDealId { get; set; }

    [ForeignKey("DeliveryPointId")]
    [InverseProperty("SosHiddenDealDeliveryPoints")]
    public virtual Point DeliveryPoint { get; set; } = null!;

    [ForeignKey("ReceiptMeterId")]
    [InverseProperty("SosHiddenDeals")]
    public virtual Meter ReceiptMeter { get; set; } = null!;

    [ForeignKey("ReceiptPointId")]
    [InverseProperty("SosHiddenDealReceiptPoints")]
    public virtual Point? ReceiptPoint { get; set; }

    [ForeignKey("SupplyDealId")]
    [InverseProperty("SosHiddenDeals")]
    public virtual Deal? SupplyDeal { get; set; }

    [ForeignKey("TransferDealId")]
    [InverseProperty("SosHiddenDeals")]
    public virtual TransferDeal? TransferDeal { get; set; }
}
