using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("sos_gas_setting")]
[Index("UserId", Name = "uk_sos_gas_setting", IsUnique = true)]
public partial class SosGasSetting
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("auto_select_point_id")]
    public int AutoSelectPointId { get; set; }

    [ForeignKey("AutoSelectPointId")]
    [InverseProperty("SosGasSettings")]
    public virtual Point AutoSelectPoint { get; set; } = null!;

    [ForeignKey("UserId")]
    [InverseProperty("SosGasSetting")]
    public virtual AppUser User { get; set; } = null!;
}
