using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("sales_tax_type")]
public partial class SalesTaxType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [InverseProperty("TaxType")]
    public virtual ICollection<SalesTaxDetail> SalesTaxDetails { get; set; } = new List<SalesTaxDetail>();
}
