using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("report_filter_parameter")]
[Index("Name", "FilterId", "DataSourceId", Name = "uk_report_filter_parameter", IsUnique = true)]
public partial class ReportFilterParameter
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("filter_id")]
    public int FilterId { get; set; }

    [Column("data_source_id")]
    public int DataSourceId { get; set; }

    [Column("preview", TypeName = "citext")]
    public string Preview { get; set; } = null!;

    [Column("value1", TypeName = "citext")]
    public string Value1 { get; set; } = null!;

    [Column("value2", TypeName = "citext")]
    public string? Value2 { get; set; }

    [ForeignKey("DataSourceId")]
    [InverseProperty("ReportFilterParameters")]
    public virtual ReportDataSource DataSource { get; set; } = null!;

    [ForeignKey("FilterId")]
    [InverseProperty("ReportFilterParameters")]
    public virtual ReportFilter Filter { get; set; } = null!;
}
