using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipeline_tariff_type")]
public partial class PipelineTariffType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("TariffType")]
    public virtual ICollection<PipelineRateDiscounted> PipelineRateDiscounteds { get; set; } = new List<PipelineRateDiscounted>();

    [InverseProperty("TariffType")]
    public virtual ICollection<PipelineTariff> PipelineTariffs { get; set; } = new List<PipelineTariff>();
}
