using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipe_contract_delivery_meter")]
[Index("PipeContractId", "MeterId", Name = "uk_pipe_contract_delivery_meter", IsUnique = true)]
public partial class PipeContractDeliveryMeter
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipe_contract_id")]
    public int PipeContractId { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [ForeignKey("MeterId")]
    [InverseProperty("PipeContractDeliveryMeters")]
    public virtual Meter Meter { get; set; } = null!;

    [ForeignKey("PipeContractId")]
    [InverseProperty("PipeContractDeliveryMeters")]
    public virtual PipelineContract PipeContract { get; set; } = null!;
}
