using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("crude_path_route")]
public partial class CrudePathRoute
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("path_id")]
    public int PathId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("meter_map_id")]
    public int? MeterMapId { get; set; }

    [Column("is_meter1_first")]
    public bool? IsMeter1First { get; set; }

    [Column("order_id")]
    public int OrderId { get; set; }

    [Column("to_pipe_contract_id")]
    public int? ToPipeContractId { get; set; }

    [ForeignKey("MeterMapId")]
    [InverseProperty("CrudePathRoutes")]
    public virtual TransferMeter? MeterMap { get; set; }

    [ForeignKey("PathId")]
    [InverseProperty("CrudePathRoutes")]
    public virtual CrudePath Path { get; set; } = null!;

    [ForeignKey("PointId")]
    [InverseProperty("CrudePathRoutes")]
    public virtual Point? Point { get; set; }

    [ForeignKey("ToPipeContractId")]
    [InverseProperty("CrudePathRoutes")]
    public virtual PipelineContract? ToPipeContract { get; set; }
}
