using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("crude_market_supply")]
[Index("Date", Name = "ix_crude_market_supply_date")]
[Index("IsActual", Name = "ix_crude_market_supply_is_actual")]
[Index("MarketNomId", Name = "ix_crude_market_supply_market_nom_id")]
[Index("SupplyNomId", Name = "ix_crude_market_supply_supply_nom_id")]
[Index("Date", "SupplyNomId", "MarketNomId", "IsActual", Name = "uk_crude_market_supply", IsUnique = true)]
public partial class CrudeMarketSupply
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("date")]
    public DateOnly Date { get; set; }

    [Column("supply_nom_id")]
    public int SupplyNomId { get; set; }

    [Column("market_nom_id")]
    public int MarketNomId { get; set; }

    [Column("volume")]
    public int? Volume { get; set; }

    [Column("comment", TypeName = "citext")]
    public string? Comment { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("is_keep_whole")]
    public bool IsKeepWhole { get; set; }

    [Column("is_actual")]
    public bool IsActual { get; set; }

    [Column("actual_volume")]
    public int? ActualVolume { get; set; }

    [ForeignKey("MarketNomId")]
    [InverseProperty("CrudeMarketSupplies")]
    public virtual CrudeMarket MarketNom { get; set; } = null!;

    [ForeignKey("SupplyNomId")]
    [InverseProperty("CrudeMarketSupplies")]
    public virtual CrudeSupply SupplyNom { get; set; } = null!;
}
