using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("actual_type")]
public partial class ActualType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("ActualType")]
    public virtual ICollection<CrudeActual> CrudeActuals { get; set; } = new List<CrudeActual>();

    [InverseProperty("ActualType")]
    public virtual ICollection<GasActual> GasActuals { get; set; } = new List<GasActual>();
}
