import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../_shared/utils/util';


@Injectable({
  providedIn: 'root'
})
export class PriceIndexPublicationService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/PriceIndexPublication`;
  http = inject(HttpClient);

  getItems(): Observable<util.IdName[]> {
    const url = `${this.baseUrl}/GetItems`;
    return this.http.get<util.IdName[]>(url);
  }

  getItemDetail(id: number): Observable<util.IdName> {
    const url = `${this.baseUrl}/GetItemDetail/${id}`;
    return this.http.get<util.IdName>(url);
  }

  saveItem(item: util.IdName) {
    const url = `${this.baseUrl}/SaveItem`;
    return this.http.put<util.IdName>(url, item);
  }

  deleteItem(id: number): Observable<util.IdName[]> {
    const url = `${this.baseUrl}/DeleteItem/${id}`;
    return this.http.delete<util.IdName[]>(url);
  }
}
