
export class Dictionary<V> extends Map<string | number, V> implements Dictionary<V> {
  set(key: string | number, value: V): this {
    const lowercaseKey = (typeof key === "string") ? key.toLowerCase() : key;
    return super.set(lowercaseKey, value);
  }

  get(key: string | number): V | undefined {
    const lowercaseKey = (typeof key === "string") ? key.toLowerCase() : key;
    return super.get(lowercaseKey);
  }

  has(key: string | number): boolean {
    const lowercaseKey = (typeof key === "string") ? key.toLowerCase() : key;
    return super.has(lowercaseKey);
  }

  delete(key: string | number): boolean {
    const lowercaseKey = (typeof key === "string") ? key.toLowerCase() : key;
    return super.delete(lowercaseKey);
  }
}
