import { Injectable } from '@angular/core';
import { IconSettingsService } from '@progress/kendo-angular-icons';
import { SVGIcon } from '@progress/kendo-svg-icons';
import * as allSVGIcons from '@progress/kendo-svg-icons';

@Injectable()
export class MyIconService extends IconSettingsService {
  private svgDictionary: { [key: string]: SVGIcon } = {
    'x-circle': allSVGIcons.xOutlineIcon //replaces the x-circle icon with the x-outline icon
  };

  public getSvgIcon(svgIconName: string): SVGIcon {
    return this.svgDictionary[svgIconName] || super.getSvgIcon(svgIconName);
  }
}
