import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'globalBarIconPipe'
})
export class GlobalBarIconPipe implements PipeTransform {
  transform(menuName: string): string {
    const accountingMenuIcon = 'images/accounting-tp.png';
    const adminMenuIcon = 'images/admin-tp.png';
    const counterpartyMenuIcon = 'images/counterparty-tp.png';
    const dataSetupMenuIcon = 'images/data-tp.png';
    const dealsMenuIcon = 'images/transaction-tp.png';
    const marketPricesMenuIcon = 'images/market-tp.png';
    const midstreamMenuIcon = 'images/midstream-tp.png';
    const reportsMenuIcon = 'images/report-tp.png';
    const schedulingMenuIcon = 'images/scheduling-tp.png';

    if (menuName === 'Accounting') {
      return accountingMenuIcon;
    }
    else if (menuName === 'Admin') {
      return adminMenuIcon;
    }
    else if (menuName === 'Counterparty') {
      return counterpartyMenuIcon;
    }
    else if (menuName === 'Data Setup') {
      return dataSetupMenuIcon;
    }
    else if (menuName === 'Deals') {
      return dealsMenuIcon;
    }
    else if (menuName === 'Market Prices') {
      return marketPricesMenuIcon;
    }
    else if (menuName === 'Midstream') {
      return midstreamMenuIcon;
    }
    else if (menuName === 'Reports') {
      return reportsMenuIcon;
    }
    else if (menuName === 'Scheduling') {
      return schedulingMenuIcon;
    }
  }
}

