import { argv } from "process";
var port = argv[7] //the 7th node argument should be the port number

if (port)
  port = "443" + port.substring(3) //replace 543 with  443

var proxyConfig = port ? getProxyConfig() : {};

if (!port) {
  console.log(`
******************************************************************************************
Port not found, proxy not configured. Perhaps use the vscode "ng serve" task in tasks.json
******************************************************************************************\n`);
}

export default proxyConfig;

function getProxyConfig() {
  // "secure: false" still uses https, but does not verify the certificate
  // production does not use this proxy
  // https://stackoverflow.com/questions/77986335/how-to-configure-proxy-with-angular-17-esbuild-vite
  return {
    "/api/**": {
      "target": "https://127.0.0.1:" + port,
      "changeOrigin": true,
      "secure": false
    },
    "/hangfire/**": {
      "target": "https://127.0.0.1:" + port,
      "secure": false
    },
    "/odata/**": {
      "target": "https://127.0.0.1:" + port,
      "secure": false
    },
    "/pdfjs/**": {
      "target": "https://127.0.0.1:" + port,
      "secure": false
    },
    "/signin-oidc": {
      "target": "https://127.0.0.1:" + port,
      "secure": false
    },
  };
}
