using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Keyless]
public partial class VwRptCreditLimit
{
    public DateOnly? ApprovedDate { get; set; }

    public DateOnly? ExpirationDate { get; set; }

    public DateOnly? ReviewedDate { get; set; }

    public string? ParentCounterparty { get; set; }

    public decimal? TotalCreditLimit { get; set; }

    public decimal? ApprovedCreditLimit { get; set; }

    public bool? OverLimitException { get; set; }

    public decimal? ExceptionAmount { get; set; }

    public DateOnly? ExceptionExpiration { get; set; }

    public string? NatGasCounterparty1 { get; set; }

    public string? NatGasCounterparty2 { get; set; }

    public decimal? NatGasCreditLimit1 { get; set; }

    public decimal? NatGasCreditLimit2 { get; set; }

    public string? NglsCounterparty1 { get; set; }

    public string? NglsCounterparty2 { get; set; }

    public decimal? NglsCreditLimit1 { get; set; }

    public decimal? NglsCreditLimit2 { get; set; }

    public string? CrudeCounterparty1 { get; set; }

    public string? CrudeCounterparty2 { get; set; }

    public decimal? CrudeCreditLimit1 { get; set; }

    public decimal? CrudeCreditLimit2 { get; set; }

    [Column(TypeName = "citext")]
    public string? CollateralProduct { get; set; }

    public decimal? CollateralAmount { get; set; }

    [Column(TypeName = "citext")]
    public string? CollateralType { get; set; }

    public DateOnly? CollateralEffectiveDate { get; set; }

    public DateOnly? CollateralExpirationDate { get; set; }

    [Column(TypeName = "citext")]
    public string? CollateralExpirationNotice { get; set; }

    [Column(TypeName = "citext")]
    public string? CollateralProviders { get; set; }

    [Column(TypeName = "citext")]
    public string? CollateralBeneficiaries { get; set; }

    public int? ParentCounterpartyId { get; set; }

    public int? NaturalGasCounterpartyId { get; set; }

    public int? NaturalGasCounterpartyId2 { get; set; }

    public int? NglsCounterpartyId { get; set; }

    public int? NglsCounterpartyId2 { get; set; }

    public int? CrudeOilCounterpartyId { get; set; }

    public int? CrudeOilCounterpartyId2 { get; set; }

    public int? ProductCategoryId { get; set; }
}
