using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("unit_of_measure_conversion")]
public partial class UnitOfMeasureConversion
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("from_unit_of_measure_id")]
    public int FromUnitOfMeasureId { get; set; }

    [Column("to_unit_of_measure_id")]
    public int ToUnitOfMeasureId { get; set; }

    [Column("conversion_factor")]
    public double ConversionFactor { get; set; }

    [ForeignKey("FromUnitOfMeasureId")]
    [InverseProperty("UnitOfMeasureConversions")]
    public virtual UnitOfMeasure FromUnitOfMeasure { get; set; } = null!;
}
