using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("sales_tax_exemption")]
[Index("CompanyId", "StateId", "ExpirationDate", Name = "uk_sales_tax_exemption", IsUnique = true)]
public partial class SalesTaxExemption
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("company_id")]
    public int CompanyId { get; set; }

    [Column("state_id")]
    public int StateId { get; set; }

    [Column("effective_date")]
    public DateOnly? EffectiveDate { get; set; }

    [Column("expiration_date")]
    public DateOnly ExpirationDate { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [ForeignKey("CompanyId")]
    [InverseProperty("SalesTaxExemptions")]
    public virtual Counterparty Company { get; set; } = null!;

    [InverseProperty("SalesTaxExemption")]
    public virtual ICollection<SalesTaxExemptionDoc> SalesTaxExemptionDocs { get; set; } = new List<SalesTaxExemptionDoc>();

    [ForeignKey("StateId")]
    [InverseProperty("SalesTaxExemptions")]
    public virtual Territory State { get; set; } = null!;
}
