using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("product")]
[Index("CategoryId", "SortIndex", Name = "uk_product", IsUnique = true)]
[Index("Name", Name = "uk_product_name", IsUnique = true)]
public partial class Product
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("description", TypeName = "citext")]
    public string Description { get; set; } = null!;

    [Column("category_id")]
    public int CategoryId { get; set; }

    [Column("sort_index")]
    public int SortIndex { get; set; }

    [Column("unit_of_measure_id")]
    public int? UnitOfMeasureId { get; set; }

    [Column("unit_price_id")]
    public int? UnitPriceId { get; set; }

    [InverseProperty("Product")]
    public virtual ICollection<ActualizationFilter> ActualizationFilters { get; set; } = new List<ActualizationFilter>();

    [ForeignKey("CategoryId")]
    [InverseProperty("Products")]
    public virtual ProductCategory Category { get; set; } = null!;

    [InverseProperty("Product")]
    public virtual ICollection<Contract> Contracts { get; set; } = new List<Contract>();

    [InverseProperty("Product")]
    public virtual ICollection<CounterpartyProduct> CounterpartyProducts { get; set; } = new List<CounterpartyProduct>();

    [InverseProperty("Product")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();

    [InverseProperty("Product")]
    public virtual ICollection<MarketIndex> MarketIndices { get; set; } = new List<MarketIndex>();

    [InverseProperty("Product")]
    public virtual ICollection<MeterProduct> MeterProducts { get; set; } = new List<MeterProduct>();

    [InverseProperty("Product")]
    public virtual ICollection<PipelineContractDefault> PipelineContractDefaults { get; set; } = new List<PipelineContractDefault>();

    [InverseProperty("Product")]
    public virtual ICollection<PipelineContract> PipelineContracts { get; set; } = new List<PipelineContract>();

    [InverseProperty("Product")]
    public virtual ICollection<PipelineRateSchedule> PipelineRateSchedules { get; set; } = new List<PipelineRateSchedule>();

    [InverseProperty("Product")]
    public virtual ICollection<PointProductGradeToIndex> PointProductGradeToIndices { get; set; } = new List<PointProductGradeToIndex>();

    [InverseProperty("Product")]
    public virtual ICollection<TransferMeter> TransferMeters { get; set; } = new List<TransferMeter>();

    [ForeignKey("UnitOfMeasureId")]
    [InverseProperty("Products")]
    public virtual UnitOfMeasure? UnitOfMeasure { get; set; }

    [ForeignKey("UnitPriceId")]
    [InverseProperty("Products")]
    public virtual UnitPriceCombination? UnitPrice { get; set; }
}
