using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipeline_rate_discounted_counterparty")]
public partial class PipelineRateDiscountedCounterparty
{
    [Column("discounted_rate_id")]
    public int DiscountedRateId { get; set; }

    [Column("entity_id")]
    public int EntityId { get; set; }

    [Key]
    [Column("id")]
    public int Id { get; set; }

    [ForeignKey("DiscountedRateId")]
    [InverseProperty("PipelineRateDiscountedCounterparties")]
    public virtual PipelineRateDiscounted DiscountedRate { get; set; } = null!;

    [ForeignKey("EntityId")]
    [InverseProperty("PipelineRateDiscountedCounterparties")]
    public virtual Counterparty Entity { get; set; } = null!;
}
