using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipeline_contract_default")]
[Index("PipelineId", "ProductId", Name = "idx_26917_IX_pipeline_contract_default", IsUnique = true)]
public partial class PipelineContractDefault
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipeline_id")]
    public int PipelineId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [Column("pipe_contract_id")]
    public int PipeContractId { get; set; }

    [ForeignKey("PipeContractId")]
    [InverseProperty("PipelineContractDefaults")]
    public virtual PipelineContract PipeContract { get; set; } = null!;

    [ForeignKey("PipelineId")]
    [InverseProperty("PipelineContractDefaults")]
    public virtual Pipeline Pipeline { get; set; } = null!;

    [ForeignKey("ProductId")]
    [InverseProperty("PipelineContractDefaults")]
    public virtual Product Product { get; set; } = null!;
}
