using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipe_rate_doc")]
public partial class PipeRateDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipeline_tariff_id")]
    public int PipelineTariffId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("PipelineTariffId")]
    [InverseProperty("PipeRateDocs")]
    public virtual PipelineTariff PipelineTariff { get; set; } = null!;
}
