using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("payment_instruction_doc")]
public partial class PaymentInstructionDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("payment_instruction_id")]
    public int PaymentInstructionId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("PaymentInstructionId")]
    [InverseProperty("PaymentInstructionDocs")]
    public virtual PaymentInstruction PaymentInstruction { get; set; } = null!;
}
