using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("meter_product")]
[Index("MeterId", "ProductId", "EffectiveDate", Name = "uk_meter_product_product_date", IsUnique = true)]
public partial class MeterProduct
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [Column("meter_type_id")]
    public int? MeterTypeId { get; set; }

    [Column("is_upstream")]
    public bool IsUpstream { get; set; }

    [Column("number", TypeName = "citext")]
    public string? Number { get; set; }

    [Column("hub_code", TypeName = "citext")]
    public string? HubCode { get; set; }

    [Column("source_zone_id")]
    public int? SourceZoneId { get; set; }

    [Column("plant_ids", TypeName = "citext")]
    public string? PlantIds { get; set; }

    [Column("description", TypeName = "citext")]
    public string? Description { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [ForeignKey("MeterId")]
    [InverseProperty("MeterProducts")]
    public virtual Meter Meter { get; set; } = null!;

    [InverseProperty("MeterProduct")]
    public virtual ICollection<MeterProductDeliveryPoint> MeterProductDeliveryPoints { get; set; } = new List<MeterProductDeliveryPoint>();

    [InverseProperty("MeterProduct")]
    public virtual ICollection<MeterProductSourcePoint> MeterProductSourcePoints { get; set; } = new List<MeterProductSourcePoint>();

    [ForeignKey("MeterTypeId")]
    [InverseProperty("MeterProducts")]
    public virtual MeterType? MeterType { get; set; }

    [ForeignKey("ProductId")]
    [InverseProperty("MeterProducts")]
    public virtual Product Product { get; set; } = null!;

    [ForeignKey("SourceZoneId")]
    [InverseProperty("MeterProducts")]
    public virtual Zone? SourceZone { get; set; }
}
