using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("location")]
[Index("Name", Name = "uk_location_name", IsUnique = true)]
public partial class Location
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("Location")]
    public virtual ICollection<Meter> Meters { get; set; } = new List<Meter>();
}
