using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("invoice_type")]
public partial class InvoiceType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("InvoiceType")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudes { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("InvoiceType")]
    public virtual ICollection<InvoiceGa> InvoiceGas { get; set; } = new List<InvoiceGa>();
}
