using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("gas_market")]
[Index("Date", "TransferDealId", "Id", Name = "ix_gas_market_date_transfer")]
[Index("DealId", "Month", Name = "ix_gas_market_deal_id_month")]
[Index("Month", Name = "ix_gas_market_month")]
[Index("DealId", "Date", "TransferDealId", "PointId", Name = "uk_gas_market", IsUnique = true)]
public partial class GasMarket
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("deal_id")]
    public int? DealId { get; set; }

    [Column("transfer_deal_id")]
    public int? TransferDealId { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [Column("point_id")]
    public int? PointId { get; set; }

    [Column("rank")]
    public int Rank { get; set; }

    [Column("date")]
    public DateOnly Date { get; set; }

    [Column("month")]
    public DateOnly Month { get; set; }

    [ForeignKey("DealId")]
    [InverseProperty("GasMarkets")]
    public virtual Deal? Deal { get; set; }

    [InverseProperty("MarketNom")]
    public virtual ICollection<GasActual> GasActuals { get; set; } = new List<GasActual>();

    [InverseProperty("MarketNom")]
    public virtual ICollection<GasMarketSupply> GasMarketSupplies { get; set; } = new List<GasMarketSupply>();

    [ForeignKey("MeterId")]
    [InverseProperty("GasMarkets")]
    public virtual Meter Meter { get; set; } = null!;

    [ForeignKey("PointId")]
    [InverseProperty("GasMarkets")]
    public virtual Point? Point { get; set; }

    [ForeignKey("TransferDealId")]
    [InverseProperty("GasMarkets")]
    public virtual TransferDeal? TransferDeal { get; set; }
}
