using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("deal_purpose_type")]
public partial class DealPurposeType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("reserved_filed1", TypeName = "citext")]
    public string? ReservedFiled1 { get; set; }

    [Column("reserved_filed2", TypeName = "citext")]
    public string? ReservedFiled2 { get; set; }

    [Column("for_physical_gas")]
    public bool? ForPhysicalGas { get; set; }

    [Column("for_crude_oil")]
    public bool? ForCrudeOil { get; set; }

    [Column("for_power")]
    public bool? ForPower { get; set; }

    [Column("for_futures")]
    public bool? ForFutures { get; set; }

    [Column("for_options")]
    public bool? ForOptions { get; set; }

    [Column("for_basis_swaps")]
    public bool? ForBasisSwaps { get; set; }

    [Column("for_ff_swaps")]
    public bool? ForFfSwaps { get; set; }

    [Column("for_otc_swaps")]
    public bool? ForOtcSwaps { get; set; }

    [Column("for_ngls")]
    public bool? ForNgls { get; set; }

    [Column("for_transport")]
    public bool? ForTransport { get; set; }

    [InverseProperty("DealPurpose")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
