using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("crude_actual")]
[Index("ActualTypeId", "SupplyNomId", "MarketNomId", "LastTransferId", "SaveDate", Name = "uk_crude_actual_actual", IsUnique = true)]
public partial class CrudeActual
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("actual_type_id")]
    public int ActualTypeId { get; set; }

    [Column("supply_nom_id")]
    public int SupplyNomId { get; set; }

    [Column("market_nom_id")]
    public int MarketNomId { get; set; }

    [Column("volume")]
    public decimal? Volume { get; set; }

    [Column("price")]
    public decimal? Price { get; set; }

    [Column("adder")]
    public decimal? Adder { get; set; }

    [Column("transport_rate")]
    public decimal? TransportRate { get; set; }

    [Column("is_linked")]
    public bool IsLinked { get; set; }

    [Column("saved_by")]
    public int SavedBy { get; set; }

    [Column("save_date")]
    public DateOnly SaveDate { get; set; }

    [Column("last_transfer_id")]
    public int? LastTransferId { get; set; }

    [Column("tne_meter_id")]
    public int? TneMeterId { get; set; }

    [Column("actual_fee")]
    public decimal? ActualFee { get; set; }

    [Column("adjustment")]
    public decimal? Adjustment { get; set; }

    [ForeignKey("ActualTypeId")]
    [InverseProperty("CrudeActuals")]
    public virtual ActualType ActualType { get; set; } = null!;

    [ForeignKey("LastTransferId")]
    [InverseProperty("CrudeActuals")]
    public virtual TransferDeal? LastTransfer { get; set; }

    [ForeignKey("MarketNomId")]
    [InverseProperty("CrudeActuals")]
    public virtual CrudeMarket MarketNom { get; set; } = null!;

    [ForeignKey("SavedBy")]
    [InverseProperty("CrudeActuals")]
    public virtual AppUser SavedByNavigation { get; set; } = null!;

    [ForeignKey("SupplyNomId")]
    [InverseProperty("CrudeActuals")]
    public virtual CrudeSupply SupplyNom { get; set; } = null!;

    [ForeignKey("TneMeterId")]
    [InverseProperty("CrudeActuals")]
    public virtual Meter? TneMeter { get; set; }
}
