using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[PrimaryKey("LoginProvider", "ProviderKey")]
[Table("asp_user_login")]
[Index("UserId", Name = "ix_asp_user_login_user_id")]
public partial class AspUserLogin
{
    [Key]
    [Column(TypeName = "citext")]
    public string LoginProvider { get; set; } = null!;

    [Key]
    [Column(TypeName = "citext")]
    public string ProviderKey { get; set; } = null!;

    [Column(TypeName = "citext")]
    public string? ProviderDisplayName { get; set; }

    public int UserId { get; set; }

    [ForeignKey("UserId")]
    [InverseProperty("AspUserLogins")]
    public virtual AppUser User { get; set; } = null!;
}
