import { Component, ChangeDetectionStrategy, ViewEncapsulation, inject } from '@angular/core';
import { Title } from '@angular/platform-browser';
import { tap } from 'rxjs/operators';
import { of, BehaviorSubject } from 'rxjs';
import { DomSanitizer } from '@angular/platform-browser';
import { GlobalBarComponent } from "../_shared/global-bar/global-bar.component";
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from '../app.config';

@Component({
  templateUrl: './jobs.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
  encapsulation: ViewEncapsulation.None,
  imports: [FAST_PAGE_COMMON, FAST_KENDO_COMMON, GlobalBarComponent]
})
export class JobsComponent {
  constructor() {
    setTimeout(() => {
      const frame = document.querySelector('#hangfireFrame iframe') as HTMLIFrameElement;
      frame.onload = () => {
        this.loading$.next(false);
      };
    });
  }

  titleService = inject(Title);
  sanitizer = inject(DomSanitizer);

  loading$ = new BehaviorSubject<boolean>(true)

  title$ = of('Jobs').pipe(
    tap((title) => this.titleService.setTitle(title))
  )
}
