import { inject, Injectable, TemplateRef } from '@angular/core';
import { NotificationService, Position, Animation } from '@progress/kendo-angular-notification';

@Injectable({ providedIn: 'root' })
export class NotifyService {
  private hideAfter = 4000;
  private position: Position = { horizontal: 'center', vertical: 'bottom' };
  private animation: Animation = { type: "slide", duration: 200 };
  private notificationService = inject(NotificationService);

  success(content: string | TemplateRef<unknown>) {
    this.show(content, 'success');
  }

  error(content: string | TemplateRef<unknown>) {
    this.show(content, 'error');
  }

  warning(content: string | TemplateRef<unknown>) {
    this.show(content, 'warning');
  }

  info(content: string | TemplateRef<unknown>) {
    this.show(content, 'info');
  }

  show(
    content: string | TemplateRef<unknown>,
    style: 'info' | 'none' | 'success' | 'warning' | 'error',
    hasAnimation: boolean = true,
    vertical: 'top' | 'bottom' = this.position.vertical,
    horizontal: 'left' | 'center' | 'right' = this.position.horizontal,
  ) {
    const newPosition: Position = { vertical: vertical, horizontal: horizontal };
    this.notificationService.show({
      content: content,
      hideAfter: this.hideAfter,
      animation: hasAnimation ? this.animation : null,
      position: newPosition,
      type: { style: style, icon: true }
    });
  }
}
