import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'winHeight'
})
export class WinHeightPipe implements PipeTransform {
  transform(maxHeight: number = 9000): number {
    if (!maxHeight || maxHeight === 0)
      maxHeight = 9000;

    if (maxHeight && maxHeight > 0 && window.innerHeight > maxHeight)
      return maxHeight;
    else
      return window.innerHeight - 50;
  }
}
