import { CommonModule } from "@angular/common";
import { ChangeDetectionStrategy, Component, computed, HostBinding, input } from "@angular/core";
import * as util from '../utils/util';
import { FAST_KENDO_COMMON, FAST_PAGE_COMMON } from "../../app.config";

type ButtonType = 'basic' | 'basic-no-width' | 'delete' | 'export' | 'primary';

@Component({
  selector: 'fast-button',
  changeDetection: ChangeDetectionStrategy.OnPush,
  standalone: true,
  imports: [CommonModule, FAST_KENDO_COMMON, FAST_PAGE_COMMON],
  template: `
  @if(type() !== 'export'){
  <button class="
    flex flex-grow h-7.5 text-sm leading-0 border-solid border-1 rounded-md pl-2 pr-2 pt-1 pb-1 gap-1 items-center justify-center cursor-pointer
    text-base-black-1000
    dark:text-base-white-500
    border-base-gray-1000
    dark:border-alt-white-1000
    hover:text-alt-blue-250
    hover:border-alt-blue-250
    hover:brightness-90
    dark:hover:brightness-150
    active:hover:sepia
    dark:hover:text-base-blue-250
    dark:hover:border-base-blue-250" [ngClass]="conditionalClasses()" [type]="type()" [disabled]="disabled()"
      [value]="value()">
      <ng-content></ng-content>
    </button>
    }
  @if(type() === 'export'){
  <button class="
    flex flex-grow h-7.5 text-sm leading-0 border-solid border-1 rounded-sm pl-2 pr-2 pt-1 pb-1 gap-1 items-center justify-center cursor-pointer
    text-base-black-1000
    dark:text-base-white-500
    border-base-gray-1000
    dark:border-alt-white-1000
    hover:text-alt-blue-250
    hover:border-alt-blue-250
    hover:brightness-90
    dark:hover:brightness-150
    active:hover:sepia
    dark:hover:text-base-blue-250
    dark:hover:border-base-blue-250" [ngClass]="conditionalClasses()" [type]="type()" [disabled]="disabled()"
      [value]="value()" [hidden]="exporting()">
      <kendo-svg-icon class="mb-0.5 min-w-auto" [icon]="icons.fileExcelIcon"></kendo-svg-icon>Export
    </button>
    <button class="
    flex flex-grow h-7.5 text-sm leading-0 border-solid border-1 rounded-sm pl-2 pr-2 pt-1 pb-1 gap-1 items-center justify-center cursor-pointer
    text-base-black-1000
    dark:text-base-white-500
    border-base-gray-1000
    dark:border-alt-white-1000
    hover:text-alt-blue-250
    hover:border-alt-blue-250
    dark:hover:text-base-blue-250
    dark:hover:border-base-blue-250" [ngClass]="conditionalClasses()" [type]="type()" [disabled]="disabled()"
      [value]="value()" [disabled]="true" [hidden]="!exporting()">
      Exporting...
    </button>
    }
  `
})
export class FastButtonComponent {
  util = util;
  icons = util.icons;

  type = input<ButtonType>('basic');
  disabled = input<boolean>(false);
  value = input<string>('');
  exporting = input<boolean>(false);
  @HostBinding('class') get hostClass() {
    if (this.type() == 'basic-no-width')
      return 'flex';
    else
      return 'flex w-28';
  }

  conditionalClasses = computed(() => {
    const classes = [] as string[];
    if (this.type() == 'basic-no-width')
      classes.push('whitespace-nowrap');

    classes.push(...this.getLightBaseClasses(this.type()));
    classes.push(...this.getDarkBaseClasses(this.type()));
    classes.push(...this.getLightActiveClasses(this.type()));
    classes.push(...this.getDarkActiveClasses(this.type()));

    const conditionalClasses = this.getConditionalClassesFromArrays(classes);
    return conditionalClasses;
  });

  getConditionalClassesFromArrays(classArray: string[]): { [key: string]: boolean } {
    const classes: { [key: string]: boolean } = {};
    classArray.forEach(className => {
      classes[className] = true;
    });
    return classes;
  }

  getLightBaseClasses(type: ButtonType) {
    if (type == 'basic' || type == 'basic-no-width' || type == 'export')
      return ["bg-gradient-to-b", "from-base-white-250", "via-base-blue-250", "to-base-blue-250"];

    if (type == 'primary')
      return ["bg-gradient-to-b", "from-base-white-250", "via-base-blue-250", "to-base-white-250"];

    if (type == 'delete')
      return ["bg-gradient-to-b", "from-base-white-250", "via-base-red-250", "to-base-red-500"];
  }

  getDarkBaseClasses(type: ButtonType) {
    if (type == 'basic' || type == 'basic-no-width' || type == 'export')
      return ["dark:bg-gradient-to-b", "dark:from-alt-blue-250", "dark:via-alt-gray-1000", "dark:to-alt-blue-750"];

    if (type == 'primary')
      return ["dark:bg-gradient-to-b", "dark:from-base-blue-250", "dark:via-alt-gray-1000", "dark:to-alt-blue-750"];

    if (type == 'delete')
      return ["dark:bg-gradient-to-b", "dark:from-alt-red-500", "dark:via-base-black-1000", "dark:to-base-black-1000"];
  }

  getLightActiveClasses(type: ButtonType) {
    if (type == 'basic' || type == 'basic-no-width' || type == 'export')
      return ["active:bg-gradient-to-b", "active:from-base-blue-250", "active:via-base-blue-250", "active:to-base-white-250"];

    if (type == 'primary')
      return ["active:bg-gradient-to-b", "active:from-base-blue-250", "active:via-base-white-250", "active:to-base-blue-250"];

    if (type == 'delete')
      return ["active:bg-gradient-to-b", "active:from-base-red-500", "active:via-base-red-250", "active:to-base-white-250"];
  }

  getDarkActiveClasses(type: ButtonType) {
    if (type == 'basic' || type == 'basic-no-width' || type == 'export')
      return ["dark:active:bg-gradient-to-b", "dark:active:from-alt-blue-750", "dark:active:via-alt-gray-1000", "dark:active:to-alt-blue-250"];

    if (type == 'primary')
      return ["dark:active:bg-gradient-to-b", "dark:active:from-alt-blue-750", "dark:active:via-alt-gray-1000", "dark:active:to-base-blue-250"];

    if (type == 'delete')
      return ["dark:active:bg-gradient-to-b", "dark:active:from-base-black-1000", "dark:active:via-base-black-1000", "dark:active:to-alt-red-500"];
  }
}
